/*
 * Decompiled with CFR 0.152.
 */
package com.frequal.jtrain.algorithm;

import com.frequal.jtrain.algorithm.LayoutAlgorithm;
import com.frequal.jtrain.model.Layout;
import com.frequal.jtrain.model.Part;
import java.util.List;
import java.util.Random;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractLayoutAlgorithm
implements LayoutAlgorithm {
    protected Layout layout;
    protected List<Part> listParts;
    protected Random random = new Random();

    @Override
    public void setPartList(List<Part> listParts) {
        this.listParts = listParts;
    }

    public void resetParts() {
        for (Part part : this.listParts) {
            part.reset();
        }
    }

    protected abstract Part pickNextPart();

    @Override
    public void run() {
        this.resetParts();
        this.layout = new Layout("Random");
        while (!this.listParts.isEmpty() && (this.layout.getParts().isEmpty() || this.layout.hasUnconnectedCps())) {
            Part part = this.pickNextPart();
            this.layout.addAndConnectPart(part);
            this.listParts.remove(part);
        }
    }

    @Override
    public Layout getLayout() {
        return this.layout;
    }
}

