/*
 * Decompiled with CFR 0.152.
 */
package com.frequal.jtrain.algorithm;

import com.frequal.jtrain.algorithm.AbstractLayoutAlgorithm;
import com.frequal.jtrain.model.Part;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public class BasicLayoutAlgorithm
extends AbstractLayoutAlgorithm {
    private Map<Part, Float> mapWeights = new HashMap<Part, Float>();

    private Part getLastPart() {
        Part part = null;
        List<Part> listParts = this.layout.getParts();
        if (!listParts.isEmpty()) {
            part = listParts.get(listParts.size() - 1);
        }
        return part;
    }

    private Part getLastNthPart(int iiReverse) {
        Part part = null;
        List<Part> listParts = this.layout.getParts();
        if (listParts.size() >= iiReverse) {
            part = listParts.get(listParts.size() - iiReverse);
        }
        return part;
    }

    private void clearWeightMap() {
        this.mapWeights.clear();
    }

    private void assignWeights() {
        for (Part part : this.listParts) {
            float fWeight = Math.abs(this.random.nextFloat()) % 1.0f;
            Part partSecondLast = this.getLastNthPart(2);
            if (this.getLastPart().isCurve() && part.isCurve() && (null == partSecondLast || !partSecondLast.isCurve())) {
                fWeight += 0.2f;
            }
            if (this.getLastPart().isStraight() && part.isStraight() && (null == partSecondLast || !partSecondLast.isStraight())) {
                fWeight += 0.2f;
            }
            if (this.getLastPart().isSpecial() && part.isSpecial()) {
                fWeight -= 0.5f;
            }
            this.mapWeights.put(part, Float.valueOf(fWeight));
        }
    }

    private Part getHighestWeighted() {
        TreeMap<Float, Part> mapParts = new TreeMap<Float, Part>();
        for (Part part : this.mapWeights.keySet()) {
            Float floatWeight = this.mapWeights.get(part);
            mapParts.put(floatWeight, part);
        }
        Float floatFirst = (Float)mapParts.lastKey();
        Part partFirst = (Part)mapParts.get(floatFirst);
        return partFirst;
    }

    public Part pickNextPart() {
        Part part = (Part)this.listParts.get(Math.abs(this.random.nextInt()) % this.listParts.size());
        if (null != this.getLastPart()) {
            this.clearWeightMap();
            this.assignWeights();
            part = this.getHighestWeighted();
        }
        return part;
    }

    public String toString() {
        return "Basic";
    }
}

