/*
 * Decompiled with CFR 0.152.
 */
package com.frequal.jtrain.export;

import com.frequal.jtrain.model.Layout;
import com.frequal.jtrain.ui.swing.Layout2DPanel;
import com.frequal.jtrain.ui.swing.LayoutDisplayPanel;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;

public class HtmlLayoutExporter {
    private File fileDirectory;
    private File fileImage2D;
    private File fileImageSchematic;
    private LayoutDisplayPanel panelSchematic;
    private Layout2DPanel panel2D;
    private String strDirectory;

    private HtmlLayoutExporter(LayoutDisplayPanel panelSchematic, Layout2DPanel panel2D, String strDirectory) {
        this.panelSchematic = panelSchematic;
        this.panel2D = panel2D;
        this.strDirectory = strDirectory;
    }

    public static HtmlLayoutExporter create(LayoutDisplayPanel panelSchematic, Layout2DPanel panel2D, String strDirectory) {
        System.out.println("dir=" + strDirectory);
        return new HtmlLayoutExporter(panelSchematic, panel2D, strDirectory);
    }

    private void setupDirectory() {
        this.fileDirectory = new File(this.strDirectory);
        this.fileDirectory.mkdirs();
    }

    private void saveImages() {
        this.fileImageSchematic = new File(this.fileDirectory, "schematic.png");
        this.panelSchematic.writeImage(this.fileImageSchematic);
        this.fileImage2D = new File(this.fileDirectory, "layout2d.png");
        this.panel2D.writeImage(this.fileImage2D);
    }

    private void saveHtml() {
        try {
            PrintWriter writer = new PrintWriter(new File(this.fileDirectory, "index.html"));
            Layout layout = this.panelSchematic.getTrackLayout();
            writer.println("<html>");
            writer.println("<head>");
            writer.println("<title>" + layout.getName() + "</title>");
            writer.println("<head>");
            writer.println("<body>");
            writer.println("<h1>" + layout.getName() + "</h1>");
            writer.println("<h2>Overhead View</h2>");
            writer.println("<img src=\"layout2d.png\">");
            writer.println("<h2>Schematic</h2>");
            writer.println("<img src=\"schematic.png\">");
            writer.println("</body>");
            writer.println("</html>");
            writer.close();
        }
        catch (IOException iox) {
            System.err.println("HTML output error: " + iox);
        }
    }

    public void export() {
        this.setupDirectory();
        this.saveImages();
        this.saveHtml();
    }
}

