/*
 * Decompiled with CFR 0.152.
 */
package com.frequal.jtrain.model;

import com.frequal.jtrain.model.Side;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;

public class ConnectionPoint {
    boolean bOut;
    float fAngle;
    Point2D pointPosition;
    Side side;
    String strSurface;
    ConnectionPoint connectionPeer;

    public ConnectionPoint(boolean bOut, float fAngle, Point2D pointPosition, String strSurface) {
        this.bOut = bOut;
        this.fAngle = fAngle;
        this.pointPosition = pointPosition;
        this.strSurface = strSurface;
    }

    public ConnectionPoint(ConnectionPoint connectionOrig) {
        this.bOut = connectionOrig.bOut;
        this.fAngle = connectionOrig.fAngle;
        this.pointPosition = (Point2D)connectionOrig.pointPosition.clone();
        this.strSurface = connectionOrig.strSurface;
    }

    public boolean isOut() {
        return this.bOut;
    }

    public float getAngle() {
        return this.fAngle;
    }

    public void invertAngle() {
        this.fAngle = 360.0f - this.fAngle;
    }

    public double getAngleRadians() {
        return Math.toRadians(this.fAngle);
    }

    public Point2D getPosition() {
        return this.pointPosition;
    }

    public void setPosition(Point2D pointNew) {
        this.pointPosition = pointNew;
    }

    public String getSurface() {
        return this.strSurface;
    }

    public void setSide(Side side) {
        this.side = side;
    }

    public Side getSide() {
        return this.side;
    }

    public void setConnectionPeer(ConnectionPoint connectionPoint) {
        this.connectionPeer = connectionPoint;
    }

    public ConnectionPoint getConnectionPeer() {
        return this.connectionPeer;
    }

    public boolean isCompatibleWith(ConnectionPoint cpOther) {
        boolean bCompatible = false;
        if (this.strSurface.equals(cpOther.strSurface) && this.bOut == !cpOther.bOut) {
            bCompatible = true;
        }
        return bCompatible;
    }

    public boolean isTouching(ConnectionPoint cpOther) {
        boolean bRightAngle;
        boolean bTouching = false;
        boolean bRightPosition = this.pointPosition.distance(cpOther.pointPosition) < 1.5;
        boolean bl = bRightAngle = Math.abs(Math.abs(this.fAngle % 360.0f - cpOther.fAngle % 360.0f) - 180.0f) < 40.0f;
        if (bRightPosition && bRightAngle) {
            bTouching = true;
        }
        return bTouching;
    }

    public void connectWithoutMoving(ConnectionPoint cpOther) {
        this.setConnectionPeer(cpOther);
        cpOther.setConnectionPeer(this);
    }

    public void connect(ConnectionPoint cpOther) {
        this.connectWithoutMoving(cpOther);
        cpOther.getSide().moveToConnect(this, cpOther);
    }

    public void transform(AffineTransform transform, float fRotationAngle) {
        transform.transform(this.pointPosition, this.pointPosition);
        this.fAngle += fRotationAngle;
    }

    public String toString(boolean bShowPeer) {
        String strDesc = String.valueOf(this.bOut ? "Out" : "In") + " " + this.strSurface + " facing " + this.fAngle + " degrees at " + this.pointPosition;
        if (this.connectionPeer != null && bShowPeer) {
            strDesc = String.valueOf(strDesc) + " connected to " + this.connectionPeer.toString(false);
        }
        return strDesc;
    }

    public String toString() {
        return this.toString(true);
    }
}

