/*
 * Decompiled with CFR 0.152.
 */
package com.frequal.jtrain.model;

import com.frequal.jtrain.model.ConnectionPoint;
import com.frequal.jtrain.model.Part;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Layout {
    private List<ConnectionPoint> listUnconnectedCps = new LinkedList<ConnectionPoint>();
    private List<Part> listParts = new ArrayList<Part>();
    private String strName;

    public Layout(String strName) {
        this.strName = strName;
    }

    public String getName() {
        return this.strName;
    }

    private void addUnconnectedCpsToList(Part part) {
        List<ConnectionPoint> listNewUnconnectedCps = part.getUnconnectedCps();
        for (int i = listNewUnconnectedCps.size() - 1; i >= 0; --i) {
            this.listUnconnectedCps.add(listNewUnconnectedCps.get(i));
        }
    }

    public void addPart(Part part) {
        this.listParts.add(part);
        this.addUnconnectedCpsToList(part);
    }

    public void addAndConnectPart(Part part) {
        this.connectPart(part);
        this.addPart(part);
    }

    private void connectPart(Part part, boolean bIfAlreadyTouching) {
        boolean bFoundMatch = false;
        List<ConnectionPoint> listNewUnconnectedCps = part.getUnconnectedCps();
        for (ConnectionPoint cpUnconnected : listNewUnconnectedCps) {
            for (int i = this.listUnconnectedCps.size() - 1; i >= 0; --i) {
                boolean bTouchingIfRequested;
                ConnectionPoint cpAvailable = this.listUnconnectedCps.get(i);
                boolean bCompatible = cpUnconnected.isCompatibleWith(cpAvailable);
                boolean bl = bTouchingIfRequested = cpUnconnected.isTouching(cpAvailable) || !bIfAlreadyTouching;
                if (!bCompatible || !bTouchingIfRequested) continue;
                if (bIfAlreadyTouching) {
                    cpAvailable.connectWithoutMoving(cpUnconnected);
                } else {
                    cpAvailable.connect(cpUnconnected);
                    bFoundMatch = true;
                }
                this.listUnconnectedCps.remove(cpAvailable);
                break;
            }
            if (!bFoundMatch) continue;
            break;
        }
    }

    private void connectPart(Part part) {
        this.connectPart(part, false);
        this.connectPart(part, true);
    }

    public List<Part> getParts() {
        return this.listParts;
    }

    public boolean hasUnconnectedCps() {
        return this.listUnconnectedCps.size() > 0;
    }

    public String toString() {
        String strDesc = "Layout with these parts: \n";
        int iiPart = 1;
        for (Part part : this.listParts) {
            strDesc = strDesc + " " + iiPart + ". " + part + "\n";
            ++iiPart;
        }
        return strDesc;
    }
}

