/*
 * Decompiled with CFR 0.152.
 */
package com.frequal.jtrain.model;

import com.frequal.jtrain.model.Layout;
import com.frequal.jtrain.model.Part;
import com.frequal.jtrain.model.PartFactory;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class LayoutFactory {
    private static Map<String, Layout> mapLayouts = new HashMap<String, Layout>();

    static Part addPart(List<Part> listParts, String strLayout, String strName, Part partPrevious) {
        Part partNew = PartFactory.create(strLayout, strName);
        listParts.add(partNew);
        partPrevious.connect(partPrevious.getSide().getConnectionPoint(0), partNew, partNew.getSide().getConnectionPoint(1));
        return partNew;
    }

    public static Layout makeLayout(String strName, List<Part> listParts) {
        Layout layout = new Layout(strName);
        for (Part part : listParts) {
            layout.addAndConnectPart(part);
        }
        LayoutFactory.addLayout(layout);
        return layout;
    }

    static Layout makeLayout(String strName, String[] astrParts) {
        List<Part> listParts = PartFactory.makePartList(astrParts);
        return LayoutFactory.makeLayout(strName, listParts);
    }

    static void addLayout(Layout layout) {
        mapLayouts.put(layout.getName(), layout);
    }

    private LayoutFactory() {
    }

    public static Layout getLayout(String strName) {
        return mapLayouts.get(strName);
    }

    public static Layout getLayout(String strName, String strFamily, String[] astrParts) {
        return LayoutFactory.makeLayout(strName, astrParts);
    }

    static {
        String[] astrParts = new String[]{"Straight8", "Straight8", "Straight8", "LargeCurve", "Straight2", "LargeCurve", "Straight4", "LargeCurve", "Straight6", "LargeCurve", "Straight8", "Straight8", "Straight8", "LargeCurve", "Straight2", "LargeCurve", "Straight4", "LargeCurve", "Straight6", "LargeCurve"};
        Layout layout = LayoutFactory.makeLayout("Sample", astrParts);
        LayoutFactory.addLayout(layout);
        String[] astrParts2 = new String[]{"Straight8", "LargeCurve", "Straight8", "LargeCurve", "LargeCurve", "LargeCurve", "MountainOverpass", "SmallCurve/1", "SmallCurve/1", "Straight8", "SmallCurve", "SmallCurve", "Straight8"};
        layout = LayoutFactory.makeLayout("Sample3", astrParts2);
        LayoutFactory.addLayout(layout);
        ArrayList<Part> listParts = new ArrayList<Part>();
        Part partA = PartFactory.create("Thomas", "Straight8");
        listParts.add(partA);
        Part partB = LayoutFactory.addPart(listParts, "Thomas", "Straight8", partA);
        Part partC = LayoutFactory.addPart(listParts, "Thomas", "LargeCurve", partB);
        Part partD = LayoutFactory.addPart(listParts, "Thomas", "Straight8", partC);
        Part partE = LayoutFactory.addPart(listParts, "Thomas", "LargeCurve", partD);
        Part partF = LayoutFactory.addPart(listParts, "Thomas", "LargeCurve", partE);
        Part partG = LayoutFactory.addPart(listParts, "Thomas", "MountainOverpass", partF);
        Part partH = LayoutFactory.addPart(listParts, "Thomas", "SmallCurve", partG);
        Part partI = LayoutFactory.addPart(listParts, "Thomas", "SmallCurve/1", partH);
        layout = new Layout("Sample2");
        for (Part part : listParts) {
            layout.addPart(part);
        }
        LayoutFactory.addLayout(layout);
    }
}

