/*
 * Decompiled with CFR 0.152.
 */
package com.frequal.jtrain.model;

import com.frequal.jtrain.model.ConnectionPoint;
import com.frequal.jtrain.model.PartDescription;
import com.frequal.jtrain.model.Side;
import java.awt.geom.AffineTransform;
import java.util.LinkedList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Part
implements Comparable {
    private PartDescription description;
    private Side sideOrig;
    private Side sidePhysical;
    private AffineTransform transformPosition;

    public Part(PartDescription description, Side sideBasis) {
        this.description = description;
        this.sideOrig = sideBasis;
        this.sidePhysical = new Side(sideBasis);
    }

    public Part(Part partOrig) {
        this.description = partOrig.description;
        this.sideOrig = partOrig.sideOrig;
        this.sidePhysical = new Side(partOrig.sidePhysical);
    }

    public static List<Part> copyList(List<Part> listPartOrig) {
        LinkedList<Part> listPart = new LinkedList<Part>();
        for (Part part : listPartOrig) {
            listPart.add(new Part(part));
        }
        return listPart;
    }

    public void connect(ConnectionPoint cpLocal, Part partOther, ConnectionPoint cpOther) {
        if (cpLocal.isCompatibleWith(cpOther)) {
            cpLocal.connect(cpOther);
        } else {
            System.out.println("ConnectionPoints not compatible");
        }
    }

    public Side getSide() {
        return this.sidePhysical;
    }

    public int getSideCount() {
        return this.description.getSides().size();
    }

    public int getSideIndex() {
        return this.description.getSides().indexOf(this.sideOrig);
    }

    public void changeToSide(int iiSide) {
        if (iiSide < this.description.getSides().size()) {
            this.sidePhysical = new Side(this.description.getSides().get(iiSide));
        }
    }

    public void reset() {
        this.changeToSide(this.getSideIndex());
    }

    public AffineTransform getTransform() {
        return this.sidePhysical.getTransform();
    }

    public String getName() {
        return this.description.getName();
    }

    List<ConnectionPoint> getUnconnectedCps() {
        return this.sidePhysical.getUnconnectedCps();
    }

    public String getFullDescription() {
        return "A " + this.description.getName() + " here: " + this.sidePhysical.toString();
    }

    public int compareTo(Object obj) {
        int iComparison = 0;
        if (!(obj instanceof Part)) {
            throw new ClassCastException("Not a Part");
        }
        iComparison = this.toString().compareTo(obj.toString());
        return iComparison;
    }

    public boolean isCurve() {
        return this.getName().indexOf("Curve") != -1;
    }

    public boolean isStraight() {
        return this.getName().indexOf("Straight") != -1;
    }

    public boolean isSpecial() {
        return this.getSideCount() == 1;
    }

    public String toString() {
        return this.description.getName() + ", " + this.sidePhysical.getName();
    }
}

