/*
 * Decompiled with CFR 0.152.
 */
package com.frequal.jtrain.model;

import com.frequal.jtrain.model.ConnectionPoint;
import com.frequal.jtrain.model.PartDescription;
import com.frequal.jtrain.model.PartDescriptionLibrary;
import com.frequal.jtrain.model.Side;
import java.awt.Color;
import java.awt.geom.Arc2D;
import java.awt.geom.Area;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.HashMap;
import java.util.Map;

public class PartDescriptionLibraryFactory {
    private static Color colorTrack = Color.yellow.darker().darker();
    private static Color colorRoad = Color.white;
    private static Map<String, PartDescriptionLibrary> mapLibraries = new HashMap<String, PartDescriptionLibrary>();

    private static PartDescription makeStraight(int iLength) {
        return PartDescriptionLibraryFactory.makeStraight("Straight", iLength, true, true);
    }

    private static PartDescription makeAdapter(String strPrefix, int iLength, boolean bFirstConnectionOut) {
        return PartDescriptionLibraryFactory.makeStraight(strPrefix, iLength, bFirstConnectionOut, false);
    }

    private static Color colorForSurface(String strSurface) {
        if ("Road".equals(strSurface)) {
            System.out.println(strSurface);
            return colorRoad;
        }
        if ("Track".equals(strSurface)) {
            System.out.println(strSurface);
            return colorTrack;
        }
        return colorTrack;
    }

    private static PartDescription makeStraight(String strPrefix, int iLength, boolean bFirstConnectionOut, boolean bSecondConnectionOpposite) {
        return PartDescriptionLibraryFactory.makeStraight(strPrefix, iLength, bFirstConnectionOut, bSecondConnectionOpposite, "ST", "Track", "SR", "Road");
    }

    private static PartDescription makeStraight(String strPrefix, int iLength, boolean bFirstConnectionOut, boolean bSecondConnectionOpposite, String strAbbrev, String strSurface, String strAbbrevFlip, String strSurfaceFlip) {
        PartDescription description = new PartDescription(strPrefix + iLength);
        Side sideA = new Side(strSurface);
        sideA.setAbbreviation(iLength + "\" " + strAbbrev);
        ConnectionPoint connA = new ConnectionPoint(bFirstConnectionOut, 0.0f, new Point2D.Float(0.0f, 0.0f), strSurface);
        sideA.addConnectionPoint(connA);
        ConnectionPoint connB = new ConnectionPoint(bSecondConnectionOpposite ^ bFirstConnectionOut, 180.0f, new Point2D.Float(-1.0f * (float)iLength, 0.0f), strSurface);
        sideA.addConnectionPoint(connB);
        Point2D.Float pointA = new Point2D.Float(0.0f, -0.8125f);
        Point2D.Float pointB = new Point2D.Float(0.0f, 0.8125f);
        Point2D.Float pointC = new Point2D.Float(-1.0f * (float)iLength, 0.8125f);
        Point2D.Float pointD = new Point2D.Float(-1.0f * (float)iLength, -0.8125f);
        sideA.addShape(new Rectangle2D.Float(-1.0f * (float)iLength, -0.8125f, 1.0f * (float)iLength, 1.625f));
        sideA.getOutline().setCenter(new Point2D.Float(-0.5f * (float)iLength, 0.0f));
        sideA.setFillColor(PartDescriptionLibraryFactory.colorForSurface(strSurface));
        description.addSide(sideA);
        Side sideB = new Side(strSurfaceFlip);
        sideB.setAbbreviation(iLength + "\" " + strAbbrevFlip);
        ConnectionPoint connC = new ConnectionPoint(bFirstConnectionOut, 0.0f, new Point2D.Float(0.0f, 0.0f), strSurfaceFlip);
        sideB.addConnectionPoint(connC);
        ConnectionPoint connD = new ConnectionPoint(bSecondConnectionOpposite ^ bFirstConnectionOut, 180.0f, new Point2D.Float(-1.0f * (float)iLength, 0.0f), strSurfaceFlip);
        sideB.addConnectionPoint(connD);
        sideB.addShape(new Line2D.Float(pointA, pointB));
        sideB.addShape(new Line2D.Float(pointB, pointC));
        sideB.addShape(new Line2D.Float(pointC, pointD));
        sideB.addShape(new Line2D.Float(pointD, pointA));
        sideB.getOutline().setCenter(new Point2D.Float(-0.5f * (float)iLength, 0.0f));
        System.out.println("Flip side of " + strPrefix);
        sideB.setFillColor(PartDescriptionLibraryFactory.colorForSurface(strSurfaceFlip));
        description.addSide(sideB);
        return description;
    }

    private static PartDescription makeCurve(String strPrefix, float fX, float fY, Color colorFill) {
        return PartDescriptionLibraryFactory.makeCurve("Track", strPrefix, "", fX, fY, colorFill);
    }

    private static PartDescription makeCurveRoad(String strPrefix, float fX, float fY, Color colorFill) {
        return PartDescriptionLibraryFactory.makeCurve("Road", strPrefix, "Road", fX, fY, colorFill);
    }

    private static PartDescription makeCurve(String strSurface, String strPrefix, String strSuffix, float fX, float fY, Color colorFill) {
        PartDescription description = new PartDescription(strPrefix + "Curve" + strSuffix);
        Side sideA = new Side(strSurface);
        sideA.setAbbreviation("C" + strSurface.substring(0, 1));
        ConnectionPoint connA = new ConnectionPoint(true, 0.0f, new Point2D.Float(0.0f, 0.0f), strSurface);
        sideA.addConnectionPoint(connA);
        ConnectionPoint connB = new ConnectionPoint(false, 225.0f, new Point2D.Float(fX, fY), strSurface);
        sideA.addConnectionPoint(connB);
        Point2D.Float pointA = new Point2D.Float(0.0f, -0.8125f);
        Point2D.Float pointB = new Point2D.Float(0.0f, 0.8125f);
        Point2D.Float pointC = new Point2D.Float(fX, fY);
        Point2D.Float pointD = new Point2D.Float(fX, fY);
        sideA.addShape(new Line2D.Float(pointA, pointB));
        sideA.addShape(new Line2D.Float(pointC, pointD));
        float fOffset = 0.8125f;
        Area areaOuter = new Area(new Arc2D.Float(fX + fY - fOffset, 2.0f * (fX + fY) - fOffset, -(fX + fY - fOffset) * 2.0f, -(fX + fY - fOffset) * 2.0f, 225.0f, 45.0f, 2));
        fOffset = -0.8125f;
        Area areaInner = new Area(new Arc2D.Float(fX + fY - fOffset, 2.0f * (fX + fY) - fOffset, -(fX + fY - fOffset) * 2.0f, -(fX + fY - fOffset) * 2.0f, 220.0f, 55.0f, 2));
        areaOuter.subtract(areaInner);
        sideA.addShape(areaOuter);
        sideA.setFillColor(colorFill);
        sideA.getOutline().setCenter(new Point2D.Float(0.5f * fX, 0.5f * fY));
        description.addSide(sideA);
        description.addFlipSide(sideA);
        return description;
    }

    private static PartDescription makeSwitchTrack(String strPrefix, float fSize) {
        PartDescription description = new PartDescription(strPrefix + "Switch");
        String strSurface = "Track";
        Side sideA = new Side(strSurface);
        sideA.setAbbreviation((int)fSize + "\" CST");
        ConnectionPoint connA = new ConnectionPoint(true, 0.0f, new Point2D.Float(0.0f, 0.0f), strSurface);
        sideA.addConnectionPoint(connA);
        ConnectionPoint connB = new ConnectionPoint(false, 180.0f, new Point2D.Float(-1.0f * fSize, 0.0f), strSurface);
        sideA.addConnectionPoint(connB);
        ConnectionPoint connC = new ConnectionPoint(false, 225.0f, new Point2D.Float(-0.67f * fSize, -1.5f), strSurface);
        sideA.addConnectionPoint(connC);
        description.addSide(sideA);
        description.addFlipSide(sideA);
        return description;
    }

    private static PartDescription makeT() {
        PartDescription description = new PartDescription("T");
        String strSurface = "Track";
        Side sideA = new Side(strSurface);
        ConnectionPoint connA = new ConnectionPoint(true, 0.0f, new Point2D.Float(0.0f, 0.0f), strSurface);
        sideA.addConnectionPoint(connA);
        ConnectionPoint connB = new ConnectionPoint(false, 180.0f, new Point2D.Float(-6.0f, 0.0f), strSurface);
        sideA.addConnectionPoint(connB);
        ConnectionPoint connC = new ConnectionPoint(false, 270.0f, new Point2D.Float(-3.0f, -3.0f), strSurface);
        sideA.addConnectionPoint(connC);
        description.addSide(sideA);
        description.addFlipSide(sideA);
        return description;
    }

    private static PartDescription makeMountainOverpass() {
        PartDescription description = new PartDescription("MountainOverpass");
        int iLength = 6;
        Side sideA = new Side("Track");
        sideA.setAbbreviation("MO");
        ConnectionPoint connA = new ConnectionPoint(true, 0.0f, new Point2D.Float(0.0f, 0.0f), "Track");
        sideA.addConnectionPoint(connA);
        ConnectionPoint connB = new ConnectionPoint(false, 180.0f, new Point2D.Float(-1.0f * (float)iLength, 0.0f), "Track");
        sideA.addConnectionPoint(connB);
        float fHalf = 0.5f * (float)iLength;
        ConnectionPoint connC = new ConnectionPoint(true, 90.0f, new Point2D.Float(-fHalf, fHalf), "Road");
        sideA.addConnectionPoint(connC);
        ConnectionPoint connD = new ConnectionPoint(false, 270.0f, new Point2D.Float(-fHalf, -fHalf), "Road");
        sideA.addConnectionPoint(connD);
        Point2D.Float pointA = new Point2D.Float(0.0f, fHalf);
        Point2D.Float pointB = new Point2D.Float(0.0f, -fHalf);
        Point2D.Float pointC = new Point2D.Float(-iLength, -fHalf);
        Point2D.Float pointD = new Point2D.Float(-iLength, fHalf);
        sideA.addShape(new Line2D.Float(pointA, pointB));
        sideA.addShape(new Line2D.Float(pointB, pointC));
        sideA.addShape(new Line2D.Float(pointC, pointD));
        sideA.addShape(new Line2D.Float(pointD, pointA));
        sideA.getOutline().setCenter(new Point2D.Float(-fHalf, 0.0f));
        description.addSide(sideA);
        return description;
    }

    private static PartDescription makeKnapfordCoveredBridge() {
        PartDescription description = new PartDescription("KnapfordCoveredBridge");
        int iLength = 6;
        Side sideA = new Side("Track");
        sideA.setAbbreviation("KCB");
        ConnectionPoint connA = new ConnectionPoint(true, 0.0f, new Point2D.Float(0.0f, 0.0f), "Track");
        sideA.addConnectionPoint(connA);
        ConnectionPoint connB = new ConnectionPoint(false, 180.0f, new Point2D.Float(-1.0f * (float)iLength, 0.0f), "Track");
        sideA.addConnectionPoint(connB);
        float fHalf = 1.0f;
        Point2D.Float pointA = new Point2D.Float(0.0f, fHalf);
        Point2D.Float pointB = new Point2D.Float(0.0f, -fHalf);
        Point2D.Float pointC = new Point2D.Float(-iLength, -fHalf);
        Point2D.Float pointD = new Point2D.Float(-iLength, fHalf);
        sideA.addShape(new Line2D.Float(pointA, pointB));
        sideA.addShape(new Line2D.Float(pointB, pointC));
        sideA.addShape(new Line2D.Float(pointC, pointD));
        sideA.addShape(new Line2D.Float(pointD, pointA));
        sideA.getOutline().setCenter(new Point2D.Float(-fHalf, 0.0f));
        sideA.setFillColor(colorTrack);
        description.addSide(sideA);
        return description;
    }

    private static PartDescription makeStopNGoStation() {
        PartDescription description = new PartDescription("StopNGoStation");
        int iLength = 3;
        Side sideA = new Side("Track");
        sideA.setAbbreviation("SGS");
        ConnectionPoint connA = new ConnectionPoint(true, 0.0f, new Point2D.Float(0.0f, 0.0f), "Track");
        sideA.addConnectionPoint(connA);
        ConnectionPoint connB = new ConnectionPoint(false, 180.0f, new Point2D.Float(-1.0f * (float)iLength, 0.0f), "Track");
        sideA.addConnectionPoint(connB);
        float fHalf = 1.0f;
        Point2D.Float pointA = new Point2D.Float(0.0f, 3.0f * fHalf);
        Point2D.Float pointB = new Point2D.Float(0.0f, -fHalf);
        Point2D.Float pointC = new Point2D.Float(-iLength, -fHalf);
        Point2D.Float pointD = new Point2D.Float(-iLength, 3.0f * fHalf);
        sideA.addShape(new Line2D.Float(pointA, pointB));
        sideA.addShape(new Line2D.Float(pointB, pointC));
        sideA.addShape(new Line2D.Float(pointC, pointD));
        sideA.addShape(new Line2D.Float(pointD, pointA));
        sideA.getOutline().setCenter(new Point2D.Float(-fHalf, fHalf));
        sideA.setFillColor(PartDescriptionLibraryFactory.colorForSurface("Track"));
        description.addSide(sideA);
        return description;
    }

    private static PartDescription makeRailCrossing() {
        PartDescription description = new PartDescription("RailCrossing");
        int iLength = 4;
        Side sideA = new Side("Track");
        sideA.setAbbreviation("RC");
        ConnectionPoint connA = new ConnectionPoint(true, 0.0f, new Point2D.Float(0.0f, 0.0f), "Track");
        sideA.addConnectionPoint(connA);
        ConnectionPoint connB = new ConnectionPoint(false, 180.0f, new Point2D.Float(-1.0f * (float)iLength, 0.0f), "Track");
        sideA.addConnectionPoint(connB);
        float fHalf = 0.5f * (float)iLength;
        ConnectionPoint connC = new ConnectionPoint(true, 90.0f, new Point2D.Float(-fHalf, fHalf), "Road");
        sideA.addConnectionPoint(connC);
        ConnectionPoint connD = new ConnectionPoint(false, 270.0f, new Point2D.Float(-fHalf, -fHalf), "Road");
        sideA.addConnectionPoint(connD);
        Point2D.Float pointA = new Point2D.Float(0.0f, fHalf);
        Point2D.Float pointB = new Point2D.Float(0.0f, -fHalf);
        Point2D.Float pointC = new Point2D.Float(-iLength, -fHalf);
        Point2D.Float pointD = new Point2D.Float(-iLength, fHalf);
        sideA.addShape(new Line2D.Float(pointA, pointB));
        sideA.addShape(new Line2D.Float(pointB, pointC));
        sideA.addShape(new Line2D.Float(pointC, pointD));
        sideA.addShape(new Line2D.Float(pointD, pointA));
        sideA.getOutline().setCenter(new Point2D.Float(-fHalf, 0.0f));
        description.addSide(sideA);
        return description;
    }

    private static PartDescription makeTurntable() {
        PartDescription description = new PartDescription("Turntable");
        String strSurface = "Track";
        Side sideA = new Side(strSurface);
        ConnectionPoint connA = new ConnectionPoint(true, 0.0f, new Point2D.Float(0.0f, 0.0f), strSurface);
        sideA.addConnectionPoint(connA);
        ConnectionPoint connB = new ConnectionPoint(false, 180.0f, new Point2D.Float(-6.0f, 0.0f), strSurface);
        sideA.addConnectionPoint(connB);
        ConnectionPoint connD = new ConnectionPoint(false, 225.0f, new Point2D.Float(-5.0f, -2.0f), strSurface);
        sideA.addConnectionPoint(connD);
        ConnectionPoint connC = new ConnectionPoint(false, 270.0f, new Point2D.Float(-3.0f, -3.0f), strSurface);
        sideA.addConnectionPoint(connC);
        ConnectionPoint connE = new ConnectionPoint(false, 315.0f, new Point2D.Float(-1.0f, -2.0f), strSurface);
        sideA.addConnectionPoint(connE);
        description.addSide(sideA);
        return description;
    }

    private PartDescriptionLibraryFactory() {
    }

    public static PartDescriptionLibrary getLibrary(String strFamily) {
        return mapLibraries.get(strFamily);
    }

    static {
        PartDescriptionLibrary libraryThomas = new PartDescriptionLibrary("Thomas");
        libraryThomas.addDescription(PartDescriptionLibraryFactory.makeStraight(8));
        libraryThomas.addDescription(PartDescriptionLibraryFactory.makeStraight(6));
        libraryThomas.addDescription(PartDescriptionLibraryFactory.makeStraight(4));
        libraryThomas.addDescription(PartDescriptionLibraryFactory.makeStraight(3));
        libraryThomas.addDescription(PartDescriptionLibraryFactory.makeStraight(2));
        libraryThomas.addDescription(PartDescriptionLibraryFactory.makeStraight("AscendingTrack", 8, true, true, "AT", "Track", "AT", "Track"));
        libraryThomas.addDescription(PartDescriptionLibraryFactory.makeAdapter("AdapterMM", 2, true));
        libraryThomas.addDescription(PartDescriptionLibraryFactory.makeAdapter("AdapterFF", 2, false));
        libraryThomas.addDescription(PartDescriptionLibraryFactory.makeCurve("Large", -8.0f, -3.0f, colorTrack));
        libraryThomas.addDescription(PartDescriptionLibraryFactory.makeCurve("Small", -4.0f, -1.5f, colorTrack));
        libraryThomas.addDescription(PartDescriptionLibraryFactory.makeCurve("ArchedViaduct", -8.0f, -3.0f, colorTrack));
        libraryThomas.addDescription(PartDescriptionLibraryFactory.makeCurveRoad("Large", -8.0f, -3.0f, colorRoad));
        libraryThomas.addDescription(PartDescriptionLibraryFactory.makeCurveRoad("Small", -4.0f, -1.5f, colorRoad));
        libraryThomas.addDescription(PartDescriptionLibraryFactory.makeSwitchTrack("Large", 6.0f));
        libraryThomas.addDescription(PartDescriptionLibraryFactory.makeSwitchTrack("Small", 3.5f));
        libraryThomas.addDescription(PartDescriptionLibraryFactory.makeT());
        libraryThomas.addDescription(PartDescriptionLibraryFactory.makeMountainOverpass());
        libraryThomas.addDescription(PartDescriptionLibraryFactory.makeKnapfordCoveredBridge());
        libraryThomas.addDescription(PartDescriptionLibraryFactory.makeStopNGoStation());
        libraryThomas.addDescription(PartDescriptionLibraryFactory.makeRailCrossing());
        libraryThomas.addDescription(PartDescriptionLibraryFactory.makeTurntable());
        mapLibraries.put("Thomas", libraryThomas);
    }
}

