/*
 * Decompiled with CFR 0.152.
 */
package com.frequal.jtrain.model;

import com.frequal.jtrain.model.Part;
import com.frequal.jtrain.model.PartDescription;
import com.frequal.jtrain.model.PartDescriptionLibrary;
import com.frequal.jtrain.model.PartDescriptionLibraryFactory;
import java.io.FileReader;
import java.io.IOException;
import java.io.LineNumberReader;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PartFactory {
    private PartFactory() {
    }

    public static Part create(String strFamily, String strRef) {
        Part partNew = null;
        PartDescriptionLibrary library = PartDescriptionLibraryFactory.getLibrary(strFamily);
        System.out.println("Looking for " + strRef + " in " + library);
        PartDescription description = library.getDescription(PartFactory.getTypeFromPartRef(strRef));
        if (null != description) {
            int iSide = PartFactory.getSideFromPartRef(strRef);
            partNew = new Part(description, description.getSides().get(iSide));
        }
        return partNew;
    }

    public static String getTypeFromPartRef(String strPartRef) {
        String strType = strPartRef;
        int iiSeparator = -1;
        iiSeparator = strPartRef.lastIndexOf(47);
        if (iiSeparator >= 0) {
            strType = strPartRef.substring(0, iiSeparator);
        }
        return strType;
    }

    public static int getSideFromPartRef(String strPartRef) {
        int iSide = 0;
        int iiSeparator = -1;
        iiSeparator = strPartRef.lastIndexOf(47);
        if (iiSeparator >= 0 && (iSide = Integer.parseInt(strPartRef.substring(iiSeparator + 1))) < 0) {
            iSide = 0;
        }
        return iSide;
    }

    public static List<Part> makePartList(String[] astrParts) {
        LinkedList<Part> listParts;
        if (astrParts.length >= 2 && astrParts[0].equals("-file")) {
            listParts = PartFactory.makePartListFromFile(astrParts[1]);
        } else {
            listParts = new LinkedList();
            for (int i = 0; i < astrParts.length; ++i) {
                Part part = PartFactory.create("Thomas", astrParts[i]);
                if (null != part) {
                    listParts.add(part);
                    continue;
                }
                System.out.println("Unable to create this part: " + astrParts[i]);
            }
        }
        return listParts;
    }

    public static List<Part> makePartListFromFile(String strFilename) {
        String[] astrParts = new String[]{};
        try {
            String strPart;
            LineNumberReader reader = new LineNumberReader(new FileReader(strFilename));
            ArrayList<String> listParts = new ArrayList<String>(20);
            while (null != (strPart = reader.readLine())) {
                listParts.add(strPart);
            }
            astrParts = listParts.toArray(astrParts);
        }
        catch (IOException iox) {
            System.err.println("Error reading part list file");
        }
        return PartFactory.makePartList(astrParts);
    }
}

