/*
 * Decompiled with CFR 0.152.
 */
package com.frequal.jtrain.model;

import com.frequal.jtrain.model.ConnectionPoint;
import com.frequal.jtrain.model.Outline2D;
import java.awt.Color;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Side {
    private AffineTransform transformToLocation = AffineTransform.getRotateInstance(0.0);
    private Color colorFill;
    private List<ConnectionPoint> listConnectionPoints = new ArrayList<ConnectionPoint>();
    private Outline2D outline = new Outline2D();
    private String strAbbreviation;
    private String strName;

    public Side(String strName) {
        this.strName = strName;
    }

    public Side(Side sideOrig) {
        this.strName = sideOrig.strName;
        this.strAbbreviation = sideOrig.strAbbreviation;
        for (ConnectionPoint connectionPoint : sideOrig.listConnectionPoints) {
            this.addConnectionPoint(new ConnectionPoint(connectionPoint));
        }
        this.outline = new Outline2D(sideOrig.outline);
        this.colorFill = sideOrig.colorFill;
    }

    public String getAbbreviation() {
        String strAbbreviationToReturn = this.strName;
        if (null != this.strAbbreviation) {
            strAbbreviationToReturn = this.strAbbreviation;
        }
        return strAbbreviationToReturn;
    }

    public void setAbbreviation(String strAbbreviation) {
        this.strAbbreviation = strAbbreviation;
    }

    public void addConnectionPoint(ConnectionPoint connectionPoint) {
        connectionPoint.setSide(this);
        this.listConnectionPoints.add(connectionPoint);
    }

    public ConnectionPoint getConnectionPoint(int iiConnectionPoint) {
        return this.listConnectionPoints.get(iiConnectionPoint);
    }

    public List<ConnectionPoint> getConnectionPoints() {
        return this.listConnectionPoints;
    }

    List<ConnectionPoint> getUnconnectedCps() {
        LinkedList<ConnectionPoint> listUnconnectedCps = new LinkedList<ConnectionPoint>();
        for (ConnectionPoint cp : this.listConnectionPoints) {
            if (null != cp.getConnectionPeer()) continue;
            listUnconnectedCps.add(cp);
        }
        return listUnconnectedCps;
    }

    public void addShape(Shape shapeNew) {
        this.outline.addShape(shapeNew);
    }

    public Outline2D getOutline() {
        return this.outline;
    }

    public void transform(AffineTransform transform, float fRotationAngle) {
        for (ConnectionPoint cp : this.listConnectionPoints) {
            cp.transform(transform, fRotationAngle);
        }
    }

    public void moveToConnect(ConnectionPoint cpStationary, ConnectionPoint cpThis) {
        float fAngleRotation = cpStationary.getAngle() + 180.0f - cpThis.getAngle();
        Point2D pointCpThis = cpThis.getPosition();
        Point2D pointCpStationary = cpStationary.getPosition();
        AffineTransform overall = AffineTransform.getRotateInstance(Math.toRadians(fAngleRotation), pointCpStationary.getX(), pointCpStationary.getY());
        AffineTransform translate = AffineTransform.getTranslateInstance(pointCpStationary.getX() - pointCpThis.getX(), pointCpStationary.getY() - pointCpThis.getY());
        overall.concatenate(translate);
        this.transform(overall, fAngleRotation);
        this.transformToLocation = overall;
    }

    public Side makeFlip() {
        Side side = new Side(this);
        for (ConnectionPoint connectionPoint : side.listConnectionPoints) {
            Point2D pointCp = connectionPoint.getPosition();
            connectionPoint.setPosition(new Point2D.Double(pointCp.getX(), -pointCp.getY()));
            connectionPoint.invertAngle();
        }
        side.outline = this.outline.flipped();
        return side;
    }

    public AffineTransform getTransform() {
        return this.transformToLocation;
    }

    public void setFillColor(Color colorFill) {
        this.colorFill = colorFill;
    }

    public Color getFillColor() {
        return this.colorFill;
    }

    public String getName() {
        return this.strName;
    }

    public String toString() {
        String strDesc = this.strName + " side with these connectionPoints: \n";
        int iiConnectionPoint = 1;
        for (ConnectionPoint connectionPoint : this.listConnectionPoints) {
            strDesc = strDesc + "  " + iiConnectionPoint + ". " + connectionPoint + "\n";
            ++iiConnectionPoint;
        }
        return strDesc;
    }
}

