/*
 * Decompiled with CFR 0.152.
 */
package com.frequal.jtrain.ui.swing;

import com.frequal.jtrain.model.ConnectionPoint;
import com.frequal.jtrain.model.Layout;
import com.frequal.jtrain.model.Outline2D;
import com.frequal.jtrain.model.Part;
import com.frequal.jtrain.model.Side;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.util.List;
import javax.imageio.ImageIO;
import javax.swing.JPanel;

public class Layout2DPanel
extends JPanel {
    private Layout layout;

    public Layout2DPanel(Layout layout) {
        this.layout = layout;
        this.setBackground(Color.white);
    }

    public void setLayout(Layout layout) {
        this.layout = layout;
        this.repaint();
    }

    public Layout getTrackLayout() {
        return this.layout;
    }

    @Override
    public void paint(Graphics gfx) {
        gfx.setColor(this.getBackground());
        gfx.fillRect(0, 0, this.getWidth(), this.getHeight());
        gfx.setColor(this.getForeground());
        Graphics2D g2d = (Graphics2D)gfx;
        g2d.transform(AffineTransform.getTranslateInstance(500.0, 600.0));
        AffineTransform transformExpand = AffineTransform.getScaleInstance(10.0, 10.0);
        for (Part part : this.layout.getParts()) {
            this.paintPart(g2d, part, transformExpand);
        }
    }

    private void paintOutline(String strAbbreviation, Graphics2D g2d, Outline2D outline, Color colorFill, AffineTransform transformSide, AffineTransform transformLayout) {
        g2d.transform(transformLayout);
        g2d.transform(transformSide);
        g2d.setStroke(new BasicStroke(0.1f));
        List<Shape> listShapes = outline.getShapes();
        for (Shape shape : listShapes) {
            if (shape instanceof Rectangle2D || shape instanceof Area) {
                g2d.setColor(colorFill);
                g2d.fill(shape);
                g2d.setColor(Color.black);
                g2d.draw(shape);
                continue;
            }
            g2d.setColor(Color.black);
            g2d.draw(shape);
        }
        g2d.setFont(g2d.getFont().deriveFont(1.0f));
        Point2D pointCenter = outline.getCenter();
        float fWidth = g2d.getFontMetrics().stringWidth(strAbbreviation);
        float fHeight = g2d.getFontMetrics().getHeight();
        g2d.drawString(strAbbreviation, (int)(pointCenter.getX() - (double)(0.5f * fWidth)), (int)(pointCenter.getY() + (double)(0.4f * fHeight)));
    }

    private void paintConnectionPointLinks(Graphics2D g2d, Side side, AffineTransform transformExpand) {
        Point2D pointPrevious = null;
        ConnectionPoint cpPrevious = null;
        int iiCp = 1;
        ConnectionPoint cpOrig = side.getConnectionPoints().get(0);
        Point2D pointOrig = (Point2D)cpOrig.getPosition().clone();
        transformExpand.transform(pointOrig, pointOrig);
        for (ConnectionPoint cp : side.getConnectionPoints()) {
            int iWidth = 5;
            if (cp.isOut()) {
                g2d.setColor(Color.black);
                g2d.setBackground(Color.black);
            } else {
                g2d.setColor(Color.red);
                g2d.setBackground(Color.white);
                iWidth = 2;
            }
            Point2D pointCp = (Point2D)cp.getPosition().clone();
            transformExpand.transform(pointCp, pointCp);
            int iXCenter = (int)pointCp.getX();
            int iYCenter = (int)pointCp.getY();
            g2d.drawOval(iXCenter - iWidth, iYCenter - iWidth, iWidth * 2, iWidth * 2);
            this.setColorFromCp(g2d, cp);
            if (null != pointPrevious && cpPrevious.getSurface().equals(cp.getSurface())) {
                g2d.drawLine((int)pointPrevious.getX(), (int)pointPrevious.getY(), (int)pointCp.getX(), (int)pointCp.getY());
            }
            int iOffset = cp.isOut() ? 0 : 10;
            g2d.drawString(" " + iiCp, (int)pointCp.getX(), (int)pointCp.getY() + iOffset);
            pointPrevious = pointCp;
            cpPrevious = cp;
            ++iiCp;
        }
        if (cpOrig.getSurface().equals(cpPrevious.getSurface())) {
            this.setColorFromCp(g2d, cpPrevious);
            g2d.drawLine((int)pointPrevious.getX(), (int)pointPrevious.getY(), (int)pointOrig.getX(), (int)pointOrig.getY());
        }
    }

    private void paintPart(Graphics2D g2d, Part part, AffineTransform transformExpand) {
        Side side = part.getSide();
        Outline2D outline = side.getOutline();
        if (outline.hasShapes()) {
            AffineTransform transformSaved = g2d.getTransform();
            this.paintOutline(side.getAbbreviation(), g2d, outline, side.getFillColor(), side.getTransform(), transformExpand);
            g2d.setTransform(transformSaved);
        } else {
            this.paintConnectionPointLinks(g2d, side, transformExpand);
        }
    }

    private void setColorFromCp(Graphics2D g2d, ConnectionPoint cp) {
        if (cp.getSurface().equals("Track")) {
            g2d.setColor(Color.black);
        } else if (cp.getSurface().equals("Road")) {
            g2d.setColor(Color.gray);
        } else {
            g2d.setColor(Color.red);
        }
    }

    public void writeImage(File fileTrackImage) {
        BufferedImage img = new BufferedImage(1000, 750, 2);
        Graphics2D g2d = img.createGraphics();
        this.paint(g2d);
        try {
            ImageIO.write((RenderedImage)img, "png", fileTrackImage);
        }
        catch (IOException e) {
            System.out.println("Error saving image");
        }
    }
}

