/*
 * Decompiled with CFR 0.152.
 */
package com.frequal.jtrain.ui.swing;

import com.frequal.jtrain.model.ConnectionPoint;
import com.frequal.jtrain.model.Layout;
import com.frequal.jtrain.model.Part;
import com.frequal.jtrain.model.Side;
import com.frequal.jtrain.ui.swing.UniverseBuilder;
import com.frequal.jtrain.ui.threed.Extruder;
import com.sun.j3d.utils.behaviors.mouse.MouseRotate;
import com.sun.j3d.utils.behaviors.mouse.MouseTranslate;
import com.sun.j3d.utils.behaviors.mouse.MouseZoom;
import com.sun.j3d.utils.universe.SimpleUniverse;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.GraphicsConfiguration;
import java.awt.Shape;
import java.awt.geom.Point2D;
import java.util.List;
import javax.media.j3d.AmbientLight;
import javax.media.j3d.Appearance;
import javax.media.j3d.BoundingSphere;
import javax.media.j3d.Bounds;
import javax.media.j3d.BranchGroup;
import javax.media.j3d.Canvas3D;
import javax.media.j3d.DirectionalLight;
import javax.media.j3d.Geometry;
import javax.media.j3d.Material;
import javax.media.j3d.Node;
import javax.media.j3d.PolygonAttributes;
import javax.media.j3d.Shape3D;
import javax.media.j3d.Transform3D;
import javax.media.j3d.TransformGroup;
import javax.swing.JPanel;
import javax.vecmath.Color3f;
import javax.vecmath.Point3d;
import javax.vecmath.Vector3d;
import javax.vecmath.Vector3f;

public class Layout3DPanel
extends JPanel {
    private BranchGroup scene;
    private Canvas3D canvas3D;
    private Layout layout;
    private TransformGroup objTrans;
    private UniverseBuilder builder;

    private TransformGroup setupOnePart(int ciPart, Part part) {
        Transform3D rotate = new Transform3D();
        Side side = part.getSide();
        rotate.rotZ(side.getConnectionPoint(0).getAngleRadians());
        ConnectionPoint cpOrig = side.getConnectionPoints().get(0);
        Point2D pointOrig = (Point2D)cpOrig.getPosition().clone();
        Transform3D tempTranslate = new Transform3D();
        tempTranslate.setTranslation(new Vector3d(0.02 * pointOrig.getX(), 0.02 * pointOrig.getY(), 0.0));
        tempTranslate.mul(rotate);
        TransformGroup objRotate = new TransformGroup(tempTranslate);
        this.addPartShapes(objRotate, part);
        this.addLighting(objRotate);
        return objRotate;
    }

    private void addLighting(TransformGroup objRotate) {
        AmbientLight lightA = new AmbientLight();
        lightA.setInfluencingBounds((Bounds)new BoundingSphere());
        objRotate.addChild((Node)lightA);
        DirectionalLight lightD1 = new DirectionalLight();
        lightD1.setInfluencingBounds((Bounds)new BoundingSphere());
        Vector3f direction = new Vector3f(-1.0f, -1.0f, -1.0f);
        direction.normalize();
        lightD1.setDirection(direction);
        lightD1.setColor(new Color3f(1.0f, 1.0f, 1.0f));
        objRotate.addChild((Node)lightD1);
    }

    private void addPartShapes(TransformGroup objRotate, Part part) {
        List<Shape> listShapes = part.getSide().getOutline().getShapes();
        for (Shape shape : listShapes) {
            Geometry geom = Extruder.extrude(shape, 0.02f);
            PolygonAttributes polyAppear = new PolygonAttributes();
            polyAppear.setCullFace(0);
            Material material = new Material();
            Color3f colorBrown = new Color3f(0.65f, 0.49f, 0.32f);
            material.setDiffuseColor(colorBrown);
            material.setSpecularColor(colorBrown);
            material.setShininess(0.6f);
            Appearance appearFull = new Appearance();
            appearFull.setMaterial(material);
            appearFull.setPolygonAttributes(polyAppear);
            Shape3D shape3d = new Shape3D(geom, appearFull);
            objRotate.addChild((Node)shape3d);
        }
    }

    private void addMouseControl(BranchGroup objRoot, TransformGroup vpTrans) {
        BoundingSphere mouseBounds = new BoundingSphere(new Point3d(), 100.0);
        MouseRotate myMouseRotate = new MouseRotate(2);
        myMouseRotate.setTransformGroup(vpTrans);
        myMouseRotate.setSchedulingBounds((Bounds)mouseBounds);
        objRoot.addChild((Node)myMouseRotate);
        MouseTranslate myMouseTranslate = new MouseTranslate(2);
        myMouseTranslate.setTransformGroup(vpTrans);
        myMouseTranslate.setSchedulingBounds((Bounds)mouseBounds);
        objRoot.addChild((Node)myMouseTranslate);
        MouseZoom myMouseZoom = new MouseZoom(2);
        myMouseZoom.setTransformGroup(vpTrans);
        myMouseZoom.setSchedulingBounds((Bounds)mouseBounds);
        objRoot.addChild((Node)myMouseZoom);
    }

    private TransformGroup fillSceneGraph(BranchGroup objRoot, Layout layout) {
        int ciChildren = objRoot.numChildren();
        for (int i = 0; i < ciChildren; ++i) {
            Node nodeChild = objRoot.getChild(i);
            if (null == nodeChild || !(nodeChild instanceof BranchGroup)) continue;
            objRoot.removeChild(nodeChild);
        }
        this.objTrans = new TransformGroup();
        this.objTrans.setCapability(18);
        this.objTrans.setCapability(17);
        objRoot.addChild((Node)this.objTrans);
        int ciPart = 0;
        for (Part part : layout.getParts()) {
            this.objTrans.addChild((Node)this.setupOnePart(ciPart, part));
            ++ciPart;
        }
        return this.objTrans;
    }

    private void setupFromLayout(Layout layout) {
        if (null != this.canvas3D) {
            this.remove((Component)this.canvas3D);
        }
        GraphicsConfiguration config = SimpleUniverse.getPreferredConfiguration();
        this.canvas3D = new Canvas3D(config);
        this.add("Center", (Component)this.canvas3D);
        this.scene = new BranchGroup();
        this.builder = new UniverseBuilder(this.canvas3D);
        TransformGroup vpTrans = this.fillSceneGraph(this.scene, layout);
        this.addMouseControl(this.scene, vpTrans);
        this.builder.addBranchGraph(this.scene);
    }

    public Layout3DPanel(Layout layout) {
        this.layout = layout;
        this.setBackground(Color.white);
        this.setLayout(new BorderLayout());
        this.setupFromLayout(layout);
    }

    public void setLayout(Layout layout) {
        this.layout = layout;
        this.setupFromLayout(layout);
    }

    public Layout getTrackLayout() {
        return this.layout;
    }

    public void writeImage(String strFilename) {
    }
}

