/*
 * Decompiled with CFR 0.152.
 */
package com.frequal.jtrain.ui.swing;

import com.frequal.jtrain.JTrain;
import com.frequal.jtrain.Version;
import com.frequal.jtrain.algorithm.LayoutAlgorithm;
import com.frequal.jtrain.export.HtmlLayoutExporter;
import com.frequal.jtrain.model.ConnectionPoint;
import com.frequal.jtrain.model.Layout;
import com.frequal.jtrain.model.LayoutExporter;
import com.frequal.jtrain.model.LayoutFactory;
import com.frequal.jtrain.model.Part;
import com.frequal.jtrain.model.PartFactory;
import com.frequal.jtrain.model.Side;
import com.frequal.jtrain.ui.swing.Layout2DPanel;
import com.frequal.jtrain.ui.swing.Layout3DPanel;
import com.frequal.jtrain.ui.swing.LayoutAlgorithmSelector;
import com.frequal.jtrain.ui.swing.PartSelector;
import com.frequal.jtrain.ui.swing.Utility;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.util.List;
import javax.imageio.ImageIO;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;

public class LayoutDisplayPanel
extends JPanel {
    private static final File fileJTrainDir = new File(new File(System.getProperty("user.home")), ".jtrain");
    private Layout layout;
    static Layout3DPanel panelLayout3DTest;
    static JTabbedPane tabbedpaneLayouts;

    public LayoutDisplayPanel(Layout layout) {
        this.layout = layout;
        this.setBackground(Color.white);
    }

    public void setLayout(Layout layout) {
        this.layout = layout;
        this.repaint();
    }

    public Layout getTrackLayout() {
        return this.layout;
    }

    @Override
    public void paint(Graphics gfx) {
        gfx.setColor(this.getBackground());
        gfx.fillRect(0, 0, this.getWidth(), this.getHeight());
        gfx.setColor(this.getForeground());
        Graphics2D g2d = (Graphics2D)gfx;
        g2d.transform(AffineTransform.getTranslateInstance(500.0, 600.0));
        AffineTransform transformExpand = AffineTransform.getScaleInstance(10.0, 10.0);
        for (Part part : this.layout.getParts()) {
            this.paintPart(g2d, part, transformExpand);
        }
    }

    private void paintPart(Graphics2D g2d, Part part, AffineTransform transformExpand) {
        Side side = part.getSide();
        Point2D pointPrevious = null;
        ConnectionPoint cpPrevious = null;
        int iiCp = 1;
        ConnectionPoint cpOrig = side.getConnectionPoints().get(0);
        Point2D pointOrig = (Point2D)cpOrig.getPosition().clone();
        transformExpand.transform(pointOrig, pointOrig);
        for (ConnectionPoint cp : side.getConnectionPoints()) {
            int iWidth = 5;
            if (cp.isOut()) {
                g2d.setColor(Color.black);
                g2d.setBackground(Color.black);
            } else {
                g2d.setColor(Color.red);
                g2d.setBackground(Color.white);
                iWidth = 2;
            }
            Point2D pointCp = (Point2D)cp.getPosition().clone();
            transformExpand.transform(pointCp, pointCp);
            int iXCenter = (int)pointCp.getX();
            int iYCenter = (int)pointCp.getY();
            g2d.drawOval(iXCenter - iWidth, iYCenter - iWidth, iWidth * 2, iWidth * 2);
            this.setColorFromCp(g2d, cp);
            if (null != pointPrevious && cpPrevious.getSurface().equals(cp.getSurface())) {
                g2d.drawLine((int)pointPrevious.getX(), (int)pointPrevious.getY(), (int)pointCp.getX(), (int)pointCp.getY());
            }
            int iOffset = cp.isOut() ? 0 : 10;
            g2d.drawString(" " + iiCp, (int)pointCp.getX(), (int)pointCp.getY() + iOffset);
            if (iiCp == 2) {
                g2d.drawString(part.getName(), (int)((pointPrevious.getX() + pointCp.getX()) / 2.0) - 25, (int)((pointPrevious.getY() + pointCp.getY()) / 2.0) - 10);
            }
            pointPrevious = pointCp;
            cpPrevious = cp;
            ++iiCp;
        }
        if (cpOrig.getSurface().equals(cpPrevious.getSurface())) {
            this.setColorFromCp(g2d, cpPrevious);
            g2d.drawLine((int)pointPrevious.getX(), (int)pointPrevious.getY(), (int)pointOrig.getX(), (int)pointOrig.getY());
        }
    }

    private void setColorFromCp(Graphics2D g2d, ConnectionPoint cp) {
        if (cp.getSurface().equals("Track")) {
            g2d.setColor(Color.black);
        } else if (cp.getSurface().equals("Road")) {
            g2d.setColor(Color.gray);
        } else {
            g2d.setColor(Color.red);
        }
    }

    public void writeImage(File fileTrackImage) {
        BufferedImage img = new BufferedImage(1000, 750, 2);
        Graphics2D g2d = img.createGraphics();
        this.paint(g2d);
        try {
            ImageIO.write((RenderedImage)img, "png", fileTrackImage);
        }
        catch (Exception xpt) {
            System.out.println("Error saving image: " + xpt);
        }
    }

    private static void setLayout3D(Layout layout) {
        if (null != panelLayout3DTest) {
            tabbedpaneLayouts.remove(panelLayout3DTest);
        }
        if (null != (panelLayout3DTest = new Layout3DPanel(layout))) {
            tabbedpaneLayouts.add("3D Layout", panelLayout3DTest);
            panelLayout3DTest.setLayout(layout);
        }
    }

    public static void main(String[] astrArgs) {
        System.out.println("JTrain version " + Version.getLongVersionString());
        if (JTrain.isExpired()) {
            System.out.println("This copy of " + JTrain.strTitle + " has expired.");
            System.out.println("Please download the latest version from:" + JTrain.strUrl);
        } else {
            Layout layout = LayoutFactory.getLayout("Sample");
            if (astrArgs.length > 0) {
                layout = LayoutFactory.getLayout("User", "Thomas", astrArgs);
            }
            System.out.println(layout);
            LayoutDisplayPanel panelSchematic = new LayoutDisplayPanel(layout);
            panelSchematic.init();
        }
    }

    public void init() {
        final JFrame frame = new JFrame("JTrain");
        frame.setLayout(new GridBagLayout());
        int iiRow = 1;
        JPanel panelLayoutControls = new JPanel();
        panelLayoutControls.setLayout(new GridBagLayout());
        Utility.constrainExpandHoriz(frame, panelLayoutControls, 1, iiRow++);
        JPanel panelPartControls = new JPanel();
        panelPartControls.setLayout(new GridBagLayout());
        Utility.constrainExpandHoriz(frame, panelPartControls, 1, iiRow++);
        tabbedpaneLayouts = new JTabbedPane();
        Utility.constrainExpandBoth(frame, tabbedpaneLayouts, 1, iiRow++);
        final Layout2DPanel panelLayout = new Layout2DPanel(this.layout);
        final LayoutDisplayPanel panelSchematic = this;
        tabbedpaneLayouts.add("2D Layout", panelLayout);
        tabbedpaneLayouts.add("Schematic", panelSchematic);
        panelLayout3DTest = null;
        try {
            LayoutDisplayPanel.setLayout3D(this.layout);
        }
        catch (NullPointerException npx) {
            System.out.println("Problem finding Java 3D: " + npx);
            npx.printStackTrace();
        }
        catch (NoClassDefFoundError nce) {
            System.out.println("Problem finding Java 3D: " + nce);
            nce.printStackTrace();
        }
        final Layout3DPanel panelLayout3D = panelLayout3DTest;
        frame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                frame.setVisible(false);
                System.exit(0);
            }
        });
        final JTextField txfStatus = new JTextField();
        Utility.constrainExpandHoriz(frame, txfStatus, 1, iiRow++);
        JButton btnSave = new JButton("Save Images");
        Utility.constrainNoGrowCenter(panelLayoutControls, btnSave, 4, 1);
        btnSave.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ace) {
                panelSchematic.writeImage(new File(fileJTrainDir, "track-schematic.png"));
                panelLayout.writeImage(new File(fileJTrainDir, "track.png"));
                if (null != panelLayout3D) {
                    panelLayout3D.writeImage("track3d.png");
                }
            }
        });
        JButton btnSaveHtml = new JButton("Save As HTML");
        Utility.constrainNoGrowCenter(panelLayoutControls, btnSaveHtml, 5, 1);
        btnSaveHtml.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ace) {
                HtmlLayoutExporter exporter = HtmlLayoutExporter.create(panelSchematic, panelLayout, new File(fileJTrainDir, "html").getAbsolutePath());
                exporter.export();
            }
        });
        final LayoutAlgorithmSelector selector = new LayoutAlgorithmSelector();
        Utility.constrainExpandHoriz(panelLayoutControls, selector, 3, 1);
        final List<Part> listPart = this.layout.getParts();
        JButton btnRelayout = new JButton("Relayout");
        Utility.constrainNoGrowCenter(panelLayoutControls, btnRelayout, 1, 1);
        btnRelayout.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ace) {
                LayoutAlgorithm algorithm = selector.getSelectedAlgorithm();
                System.out.println("Relayout with this algorithm: " + algorithm);
                if (null != algorithm) {
                    List<Part> listPartNew = Part.copyList(listPart);
                    algorithm.setPartList(listPartNew);
                    algorithm.run();
                    panelSchematic.setLayout(algorithm.getLayout());
                    panelLayout.setLayout(algorithm.getLayout());
                    LayoutDisplayPanel.setLayout3D(algorithm.getLayout());
                }
            }
        });
        JButton btnRelayoutGood = new JButton("Relayout Until Good");
        Utility.constrainNoGrowCenter(panelLayoutControls, btnRelayoutGood, 2, 1);
        btnRelayoutGood.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ace) {
                block1: {
                    List<Part> listPartNew;
                    Layout layout;
                    LayoutAlgorithm algorithm = selector.getSelectedAlgorithm();
                    if (null == algorithm) break block1;
                    do {
                        listPartNew = Part.copyList(listPart);
                        algorithm.setPartList(listPartNew);
                        algorithm.run();
                    } while ((layout = algorithm.getLayout()).hasUnconnectedCps());
                    panelSchematic.setLayout(layout);
                    panelLayout.setLayout(layout);
                    LayoutDisplayPanel.setLayout3D(layout);
                    txfStatus.setText("" + listPartNew.size() + " unused parts.");
                }
            }
        });
        final PartSelector partselector = new PartSelector();
        Utility.constrainExpandHoriz(panelPartControls, partselector, 2, 1);
        JButton btnAdd = new JButton("Add");
        Utility.constrainNoGrowLeft(panelPartControls, btnAdd, 1, 1);
        btnAdd.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ace) {
                Part part = new Part(partselector.getSelectedPart());
                panelSchematic.getTrackLayout().addAndConnectPart(part);
                panelLayout.repaint();
                LayoutDisplayPanel.setLayout3D(panelSchematic.getTrackLayout());
                panelSchematic.repaint();
                LayoutDisplayPanel.this.setLayout(panelSchematic.getTrackLayout());
            }
        });
        JButton btnSaveLayout = new JButton("Save Layout");
        Utility.constrainNoGrowLeft(panelPartControls, btnSaveLayout, 3, 1);
        btnSaveLayout.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ace) {
                try {
                    LayoutExporter.export(LayoutDisplayPanel.this.getTrackLayout(), new File(fileJTrainDir, "new.layout"));
                }
                catch (IOException iox) {
                    System.out.println("Exception saving the layout: " + iox);
                }
            }
        });
        JButton btnOpenLayout = new JButton("Open Layout");
        Utility.constrainNoGrowLeft(panelPartControls, btnOpenLayout, 4, 1);
        btnOpenLayout.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ace) {
                try {
                    JFileChooser fc = new JFileChooser(fileJTrainDir);
                    int returnVal = fc.showOpenDialog(frame);
                    if (returnVal == 0) {
                        List<Part> listParts = PartFactory.makePartListFromFile(fc.getSelectedFile().getPath());
                        Layout layoutOpened = LayoutFactory.makeLayout("New", listParts);
                        panelSchematic.setLayout(layoutOpened);
                        panelLayout.setLayout(layoutOpened);
                        LayoutDisplayPanel.setLayout3D(layoutOpened);
                    }
                }
                catch (Exception xpt) {
                    System.out.println("Exception opening the layout: " + xpt);
                }
            }
        });
        frame.pack();
        frame.setSize(1000, 750);
        frame.setVisible(true);
        frame.setExtendedState(6);
    }
}

