/*
 * Decompiled with CFR 0.152.
 */
package com.frequal.jtrain.ui.threed;

import com.sun.j3d.utils.geometry.GeometryInfo;
import com.sun.j3d.utils.geometry.NormalGenerator;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.PathIterator;
import java.util.Vector;
import javax.media.j3d.Geometry;
import javax.media.j3d.GeometryArray;
import javax.media.j3d.IndexedQuadArray;
import javax.media.j3d.Transform3D;
import javax.vecmath.Point3f;
import javax.vecmath.Vector3f;

public class Extruder {
    public static Point3f makePoint(float fX, float fY) {
        return new Point3f(fX * 0.02f, fY * 0.02f, 0.0f);
    }

    public static Geometry extrude(Shape shape, float fDepth) {
        PathIterator iter = shape.getPathIterator(new AffineTransform());
        Vector<Point3f> ptsList = new Vector<Point3f>();
        float[] seg = new float[6];
        float x = 0.0f;
        float y = 0.0f;
        float x0 = 0.0f;
        float y0 = 0.0f;
        while (!iter.isDone()) {
            int segType = iter.currentSegment(seg);
            switch (segType) {
                case 0: {
                    x = x0 = seg[0];
                    y = y0 = seg[1];
                    ptsList.add(Extruder.makePoint(x, y));
                    break;
                }
                case 1: {
                    x = seg[0];
                    y = seg[1];
                    ptsList.add(Extruder.makePoint(x, y));
                    break;
                }
                case 2: {
                    float yi;
                    float xi;
                    float t;
                    int i;
                    for (i = 1; i < 10; ++i) {
                        t = (float)i / 10.0f;
                        xi = (1.0f - t) * (1.0f - t) * x + 2.0f * t * (1.0f - t) * seg[0] + t * t * seg[2];
                        yi = (1.0f - t) * (1.0f - t) * y + 2.0f * t * (1.0f - t) * seg[1] + t * t * seg[3];
                        ptsList.add(Extruder.makePoint(xi, yi));
                    }
                    x = seg[2];
                    y = seg[3];
                    ptsList.add(Extruder.makePoint(x, y));
                    break;
                }
                case 3: {
                    float yi;
                    float xi;
                    float t;
                    int i;
                    for (i = 1; i < 20; ++i) {
                        t = (float)i / 20.0f;
                        xi = (1.0f - t) * (1.0f - t) * (1.0f - t) * x + 3.0f * t * (1.0f - t) * (1.0f - t) * seg[0] + 3.0f * t * t * (1.0f - t) * seg[2] + t * t * t * seg[4];
                        yi = (1.0f - t) * (1.0f - t) * (1.0f - t) * y + 3.0f * t * (1.0f - t) * (1.0f - t) * seg[1] + 3.0f * t * t * (1.0f - t) * seg[3] + t * t * t * seg[5];
                        ptsList.add(Extruder.makePoint(xi, yi));
                    }
                    x = seg[2];
                    y = seg[3];
                    ptsList.add(Extruder.makePoint(x, y));
                    break;
                }
                case 4: {
                    x = x0;
                    y = y0;
                    ptsList.add(Extruder.makePoint(x, y));
                }
            }
            iter.next();
        }
        int n = ptsList.size();
        IndexedQuadArray qa = new IndexedQuadArray(2 * n, 1, 4 * (n - 1));
        Transform3D trans = new Transform3D();
        trans.setTranslation(new Vector3f(0.0f, 0.0f, fDepth));
        for (int i = 0; i < n; ++i) {
            Point3f pt = (Point3f)ptsList.get(i);
            qa.setCoordinate(2 * i, pt);
            trans.transform(pt);
            qa.setCoordinate(2 * i + 1, pt);
        }
        int quadIndex = 0;
        for (int i = 0; i < n - 1; ++i) {
            qa.setCoordinateIndex(quadIndex++, 2 * i);
            qa.setCoordinateIndex(quadIndex++, 2 * i + 1);
            qa.setCoordinateIndex(quadIndex++, 2 * (i + 1) + 1);
            qa.setCoordinateIndex(quadIndex++, 2 * (i + 1));
        }
        GeometryInfo gi = new GeometryInfo((GeometryArray)qa);
        NormalGenerator ng = new NormalGenerator();
        ng.generateNormals(gi);
        return gi.getGeometryArray();
    }
}

